<?php

namespace Incevio\Package\Wallet\Traits;

use App\Models\Shop;
use App\Models\Customer;
use Illuminate\Support\Facades\Auth;

trait HasTransaction
{
  /**
   * Get the wallet based on user type
   *
   * @return Shop | Customer
   */
  public static function getWallet($user = 'customer', $email = null)
  {
    if ($email) {                                     // Find the user and return
      if ($user == 'customer') {
        return Customer::where('email', $email)->first();
      }

      return Shop::where('email', $email)->first();     // Merchant
    }

    if (Auth::guard('customer')->check()) {           // Return loggened in user's wallet
      return Auth::guard('customer')->user();
    }

    return Auth::guard('web')->user()->shop;
  }

  /**
   * Get the route name based on user type
   *
   * @return string
   */
  public static function getRouteName(string $to = 'deposit')
  {
    if ($to == 'wallet') {                                  // On success route to the wallet page
      return Auth::guard('customer')->check() ? 'customer.account.wallet' : 'merchant.wallet';
    }

    if (Auth::guard('customer')->check()) {                 // Customer deposit route
      return 'customer.account.wallet.deposit.form';
    }

    return 'merchant.wallet.deposit.form';                  // Merchant deposit route
  }
}
